/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.config.ConfigurableField;
import jace.config.Name;
import jace.core.Card;
import jace.core.Computer;
import jace.core.Motherboard;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import jace.core.SoundMixer;
import jace.core.Utility;
import jace.hardware.mockingboard.PSG;
import jace.hardware.mockingboard.R6522;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

@Name(value="Mockingboard")
public class CardMockingboard
extends Card
implements Runnable {
    static final int[] AY_ADDRESSES = new int[]{0, 128, 16, 144};
    @ConfigurableField(name="Volume", shortName="vol", category="Sound", description="Mockingboard volume, 100=max, 0=silent")
    public int volume = 100;
    public static int MAX_AMPLITUDE = Short.MAX_VALUE;
    @ConfigurableField(name="Phasor mode", category="Sound", description="If enabled, card will have 4 sound chips instead of 2")
    public boolean phasorMode = false;
    @ConfigurableField(name="Clock Rate (hz)", category="Sound", defaultValue="1020484", description="Clock rate of AY oscillators")
    public int CLOCK_SPEED = 1020484;
    public int SAMPLE_RATE = 48000;
    @ConfigurableField(name="Buffer size", category="Sound", description="Number of samples to generate on each pass")
    public int BUFFER_LENGTH = 64;
    public PSG[] chips;
    public R6522[] controllers;
    private int ticksBeteenPlayback = 5000;
    Lock timerSync = new ReentrantLock();
    Condition cpuCountReached = this.timerSync.newCondition();
    Condition playbackFinished = this.timerSync.newCondition();
    @ConfigurableField(name="Idle sample threshold", description="Number of samples to wait before suspending sound")
    private int MAX_IDLE_SAMPLES = this.SAMPLE_RATE;
    RAMListener mainListener = null;
    PSG activeChip = null;
    long ticksSinceLastPlayback = 0L;
    public static int[] VolTable;
    int[][] buffers;
    int bufferLength = -1;
    Thread playbackThread = null;
    boolean pause = false;

    @Override
    public String getDeviceName() {
        return "Mockingboard";
    }

    public CardMockingboard() {
        this.controllers = new R6522[2];
        for (int i = 0; i < 2; ++i) {
            final int j = i;
            this.controllers[i] = new R6522(){

                @Override
                public void sendOutputA(int value) {
                    if (CardMockingboard.this.activeChip != null) {
                        CardMockingboard.this.activeChip.setBus(value);
                    } else {
                        System.out.println("No active AY chip!");
                    }
                }

                @Override
                public void sendOutputB(int value) {
                    if (CardMockingboard.this.activeChip != null) {
                        CardMockingboard.this.activeChip.setControl(value & 7);
                    } else {
                        System.out.println("No active AY chip!");
                    }
                }

                @Override
                public int receiveOutputA() {
                    return CardMockingboard.this.activeChip == null ? 0 : CardMockingboard.this.activeChip.bus;
                }

                @Override
                public int receiveOutputB() {
                    return 0;
                }

                @Override
                public String getShortName() {
                    return "timer" + j;
                }
            };
        }
    }

    @Override
    public void reset() {
        this.suspend();
        if (this.chips != null) {
            for (PSG psg : this.chips) {
                psg.reset();
            }
        }
    }

    @Override
    protected void handleFirmwareAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
        this.activeChip = null;
        this.resume();
        int chip = 0;
        for (PSG psg : this.chips) {
            if (psg.getBaseReg() == (register & 0xF0)) {
                this.activeChip = psg;
                break;
            }
            ++chip;
        }
        if (this.activeChip == null) {
            System.err.println("Could not determine which PSG to communicate to");
            e.setNewValue(Computer.getComputer().getVideo().getFloatingBus());
            return;
        }
        R6522 controller = this.controllers[chip & 1];
        if (e.getType().isRead()) {
            int val = controller.readRegister(register & 0xF);
            e.setNewValue(val);
        } else {
            controller.writeRegister(register & 0xF, e.getNewValue());
        }
    }

    @Override
    protected void handleIOAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
        e.setNewValue(Computer.getComputer().getVideo().getFloatingBus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tick() {
        for (R6522 c : this.controllers) {
            if (c == null || !c.isRunning()) continue;
            c.tick();
        }
        if (this.isRunning() && !this.pause) {
            this.timerSync.lock();
            try {
                ++this.ticksSinceLastPlayback;
                if (this.ticksSinceLastPlayback >= (long)this.ticksBeteenPlayback) {
                    this.cpuCountReached.signalAll();
                    while (this.isRunning() && this.ticksSinceLastPlayback >= (long)this.ticksBeteenPlayback) {
                        if (this.playbackFinished.await(1L, TimeUnit.SECONDS)) continue;
                        Utility.gripe("The mockingboard playback thread has stalled.  Disabling mockingboard.");
                        this.suspend();
                    }
                }
            }
            catch (InterruptedException ex) {
                this.suspend();
            }
            finally {
                this.timerSync.unlock();
            }
        }
    }

    @Override
    public void reconfigure() {
        boolean restart = this.suspend();
        this.initPSG();
        for (PSG chip : this.chips) {
            chip.setRate(this.CLOCK_SPEED, this.SAMPLE_RATE);
            chip.reset();
        }
        super.reconfigure();
        if (restart) {
            this.resume();
        }
    }

    public void playSound(int[] left, int[] right) {
        this.chips[0].update(left, true, left, false, left, false, this.BUFFER_LENGTH);
        this.chips[1].update(right, true, right, false, right, false, this.BUFFER_LENGTH);
        if (this.phasorMode) {
            this.chips[2].update(left, false, left, false, left, false, this.BUFFER_LENGTH);
            this.chips[3].update(right, false, right, false, right, false, this.BUFFER_LENGTH);
        }
    }

    public void buildMixerTable() {
        VolTable = new int[16];
        int numChips = this.phasorMode ? 4 : 2;
        double out = (double)MAX_AMPLITUDE * (double)this.volume / 100.0;
        out = out * 2.0 / 3.0 / (double)numChips;
        double delta = 1.15;
        for (int i = 15; i > 0; --i) {
            CardMockingboard.VolTable[i] = (int)Math.round(out);
            out /= (delta += 0.0225);
        }
        CardMockingboard.VolTable[0] = 0;
    }

    @Override
    public void resume() {
        this.pause = false;
        if (!this.isRunning()) {
            if (this.chips == null) {
                this.initPSG();
            }
            for (R6522 controller : this.controllers) {
                controller.attach();
                controller.resume();
            }
        }
        super.resume();
        if (this.playbackThread == null || !this.playbackThread.isAlive()) {
            this.playbackThread = new Thread((Runnable)this, "Mockingboard sound playback");
            this.playbackThread.start();
        }
    }

    @Override
    public boolean suspend() {
        super.suspend();
        for (R6522 controller : this.controllers) {
            controller.suspend();
            controller.detach();
        }
        if (this.playbackThread == null || !this.playbackThread.isAlive()) {
            return false;
        }
        if (this.playbackThread != null) {
            this.playbackThread.interrupt();
            try {
                this.playbackThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.playbackThread = null;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            SourceDataLine out = Motherboard.mixer.getLine(this);
            int[] leftBuffer = new int[this.BUFFER_LENGTH];
            int[] rightBuffer = new int[this.BUFFER_LENGTH];
            int frameSize = out.getFormat().getFrameSize();
            byte[] buffer = new byte[this.BUFFER_LENGTH * frameSize];
            System.out.println("Mockingboard playback started");
            int bytesPerSample = frameSize / 2;
            this.buildMixerTable();
            this.ticksBeteenPlayback = (int)(Motherboard.SPEED * (long)this.BUFFER_LENGTH / (long)this.SAMPLE_RATE);
            this.ticksSinceLastPlayback = 0L;
            int zeroSamples = 0;
            block28: while (this.isRunning()) {
                Motherboard.requestSpeed(this);
                this.playSound(leftBuffer, rightBuffer);
                int p = 0;
                for (int idx = 0; idx < this.BUFFER_LENGTH; p += frameSize, ++idx) {
                    int sampleL = leftBuffer[idx];
                    int sampleR = rightBuffer[idx];
                    zeroSamples = sampleL == 0 && sampleR == 0 ? ++zeroSamples : 0;
                    int index = 0;
                    for (int shift = SoundMixer.BITS - 8; shift >= 0; shift -= 8, ++index) {
                        buffer[p + index] = (byte)(sampleR >> shift);
                        buffer[p + index + bytesPerSample] = (byte)(sampleL >> shift);
                    }
                }
                try {
                    this.timerSync.lock();
                    this.ticksSinceLastPlayback -= (long)this.ticksBeteenPlayback;
                }
                finally {
                    this.timerSync.unlock();
                }
                out.write(buffer, 0, buffer.length);
                if (zeroSamples >= this.MAX_IDLE_SAMPLES) {
                    zeroSamples = 0;
                    this.pause = true;
                    Motherboard.cancelSpeedRequest(this);
                    while (this.pause && this.isRunning()) {
                        try {
                            Thread.sleep(50L);
                            this.timerSync.lock();
                            this.playbackFinished.signalAll();
                        }
                        catch (InterruptedException ex) {
                            try {
                                this.timerSync.unlock();
                            }
                            catch (IllegalMonitorStateException ex2) {
                                // empty catch block
                            }
                            Motherboard.cancelSpeedRequest(this);
                            System.out.println("Mockingboard playback stopped");
                            Motherboard.mixer.returnLine(this);
                            return;
                            catch (IllegalMonitorStateException ex3) {
                                try {
                                    this.timerSync.unlock();
                                }
                                catch (IllegalMonitorStateException ex4) {}
                                continue;
                                catch (Throwable throwable) {
                                    try {
                                        this.timerSync.unlock();
                                        throw throwable;
                                    }
                                    catch (IllegalMonitorStateException ex5) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                            }
                        }
                        try {
                            this.timerSync.unlock();
                        }
                        catch (IllegalMonitorStateException ex) {}
                    }
                }
                try {
                    this.timerSync.lock();
                    this.playbackFinished.signalAll();
                    while (true) {
                        if (!this.isRunning() || this.ticksSinceLastPlayback >= (long)this.ticksBeteenPlayback) continue block28;
                        this.cpuCountReached.await();
                    }
                }
                catch (InterruptedException ex) {}
                continue;
                finally {
                    this.timerSync.unlock();
                }
            }
            return;
        }
        catch (LineUnavailableException ex) {
            Logger.getLogger(CardMockingboard.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        finally {
            Motherboard.cancelSpeedRequest(this);
            System.out.println("Mockingboard playback stopped");
            Motherboard.mixer.returnLine(this);
        }
    }

    private void initPSG() {
        int max = this.phasorMode ? 4 : 2;
        this.chips = new PSG[max];
        for (int i = 0; i < max; ++i) {
            this.chips[i] = new PSG(AY_ADDRESSES[i], this.CLOCK_SPEED, this.SAMPLE_RATE, "AY" + i);
        }
    }

    @Override
    protected void handleC8FirmwareAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
    }

    @Override
    public boolean suspendWithCPU() {
        return true;
    }
}

